// Header File
// Created 14/03/2004; 16:02:43
//Collision monstres avec objets...

#define MIN_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER	8
#define MAX_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER	18

#define ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER			25

//Change trajectoire
void Monsters_SetMove (unsigned char item)
{
	//Nombre alatoire
	unsigned char rnd=GCL_Random (2);
	
	//Collision suivant x
	if (Monster [item]->xmove)
	{
		rnd=GCL_Random (3);
		
		//Trajectoire oppose
		if (!rnd)
			Monster [item]->xmove=-Monster [item]->xmove;
		//Nouvelle trajectoire
		else {
			Monster [item]->xmove=0;
			if (rnd==1) Monster [item]->ymove=-1;
			else Monster [item]->ymove=1;}
	}
	//Collision suivant y
	else
	{
		rnd=GCL_Random (3);
		
		//Trajectoire oppose
		if (!rnd)
			Monster [item]->ymove=-Monster [item]->ymove;
		//Nouvelle trajectoire
		else {
			Monster [item]->ymove=0;
			if (rnd==1) Monster [item]->xmove=-1;
			else Monster [item]->xmove=1;}
	}
}

//Collision monstre avec cran
void Monsters_CollideWithScreen (void)
{	
	//Parcours monstres
	for (int i=0;i<nbrMonster;i++)
	{		
		//Gestion ombres
		Monster [i]->flag_shadow=TRUE;
		
		if ((Monster [i]->xpos+16+3>GAME_WIDTH2) || (Monster [i]->ypos+16+3>GAME_HEIGHT2))
			Monster [i]->flag_shadow=FALSE;
		
		//Collision suivant x
		if (Monster [i]->xpos<START_X)
		{
			//Replacement monstre
			Monster [i]->xpos=START_X;
			Monsters_SetMove (i);
		}
		else if ((Monster [i]->xpos+16)>GAME_WIDTH2)
		{
			//Replacement du monstre
			Monster [i]->xpos=GAME_WIDTH2-16;
			Monsters_SetMove (i);
		}
		
		//Collision suivant y zone haute
		if (Monster [i]->ypos<START_Y)
		{
			//Replacement du monstre
			Monster [i]->ypos=START_Y;
			Monsters_SetMove (i);
		}
		//Collision suivant y zone basse
		else if ((Monster [i]->ypos+15)>GAME_HEIGHT2)
			//Efface monstre
			DeleteMonster (i--);
	}
}

//Collision Monstres avec briques
void Monsters_CollideWithBlock (void)
{
	short block_x0, block_y0;
	short block_x[5], block_y[5];
	short block_n;
	
	short collide;
	unsigned char block;

	//Parcours Monstres
	for (int i=0;i<nbrMonster;i++)
	{
		//Si dans zone briques
		if (Monster [i]->ypos<=BLOCKS_ENDZONE)
		{
			block_n=0;
			
			//Brique du milieu
			block_x0=((Monster [i]->xpos+8)-START_X)/BLOCK_SIZEX;
			block_y0=((Monster [i]->ypos+8)-START_Y)/BLOCK_SIZEY;
			
			//Si non dpassement de capacit
			if ((block_x0>=0) && (block_x0<13) && (block_y0>=0) && (block_y0<18))
			{ 
				//Collision centre
				block_x [block_n]=block_x0;
				block_y [block_n++]=block_y0;
			
				//Collision brique x
				if ((block_x0-1)>=0) {
					block_x [block_n]=block_x0-1;
					block_y [block_n++]=block_y0;}
			
				if ((block_x0+1)<13) {
					block_x [block_n]=block_x0+1;
					block_y [block_n++]=block_y0;}
				
				//Collision brique y
				if ((block_y0-1)>=0) {
					block_x [block_n]=block_x0;
					block_y [block_n++]=block_y0-1;}
			
				if ((block_y0+1)<18) {
					block_x [block_n]=block_x0;
					block_y [block_n++]=block_y0+1;}
								
				//Parcours briques collisions
				for (int j=0;j<block_n;j++)
				{
					block=LevelMap [block_y [j]][block_x [j]];
				
					if (block&0x0F)
					{
						//Coordonnes du bloc en cours
						block_x0=(block_x [j]*BLOCK_SIZEX)+START_X;
						block_y0=(block_y [j]*BLOCK_SIZEY)+START_Y;
						
						//Test de collision
						collide=TestCollideSquare (block_x0, block_y0, Monster [i]->xpos, Monster [i]->ypos, BLOCK_SIZEX-2, BLOCK_SIZEY-2, 13, 13);
						
						//Collision
						if (collide)
						{
							//Replacement du monstre
							Monster [i]->xpos-=Monster [i]->xmove*collide;
							Monster [i]->ypos-=Monster [i]->ymove*collide;
							
							//Monsters_SetMove (i);
							Monster [i]->xmove=-Monster [i]->xmove;
							Monster [i]->ymove=-Monster [i]->ymove;
							break;
						}
					}
				}
			}
		}
	}
}

//Collisions avec bricks spciales
void Monsters_CollideWithBlock_Special (void)
{
	short collide;
	
	//Parcours monstres
	for (int i=0; i<nbrMonster; i++)
	{
		//Si dans zone de briques
		if (Monster [i]->ypos<=BLOCKS_ENDZONE && !Monster [i]->dead)
		{
			for (unsigned short j=0;j<bricks_special_move_n;j++)
			{
				if (!MAP_bricks_special_move_destroy [j])
				{
					//Test de collision
					collide=TestCollideSquare (MAP_bricks_special_move_x [j], MAP_bricks_special_move_y [j], Monster [i]->xpos, Monster [i]->ypos, BLOCK_SIZEX-2, BLOCK_SIZEY-2, 13, 13);
									
					//Si collision
					if (collide)
					{	
						//Replacement du monstre
						Monster [i]->xpos-=Monster [i]->xmove*collide;
						Monster [i]->ypos-=Monster [i]->ymove*collide;
							
						//Monsters_SetMove (i);
						Monster [i]->xmove=-Monster [i]->xmove;
						Monster [i]->ymove=-Monster [i]->ymove;
						break;
					}
				}
			}
		}
	}
}

//Collision monstre avec Bille
void Monsters_CollideWidthBille (void)
{
	short collide;
	short rad;

	//Parcours billes
	for (int i=0; i<nbrBille; i++)
	{
		//Parcours monstres
		for (int j=0; j<nbrMonster; j++)
		{
			//Test collision
			collide=TestCollideSquare (Bille [i]->xpos, Bille [i]->ypos, Monster [j]->xpos, Monster [j]->ypos, BLOCK_SIZEX-2, BLOCK_SIZEY-2, 13, 13);
			
			//Si collision
			if (collide && !Monster [j]->dead)
			{
				//Efface monstre
				CREATE_ANIM_MONSTER_DEAD (j);
				
				//Change de direction
				rad=GCL_Random (256);
				
				//AEvite les mauvais angles
				if (rad<ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER	) rad=ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>(64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER) && rad<=64) rad=64-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>64 && rad<(64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=64+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=128 && rad>(128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>128 && rad<(128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=128+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=192 && rad>(192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad>192 && rad<(192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=192+ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
				else if (rad<=256 && rad>(256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER)) rad=256-ANGLE_VAR_COLLIDE_BILLE_WIDTH_MONSTER;
					
				//Change angle bille
				AngleBille (i, rad);
				
				//Variation de vitesse
				ChangeBilleSpeed (i, Bille [i]->speed+GCL_Random (MAX_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER)+MIN_VARSPEED_COLLIDE_BILLE_WIDTH_MONSTER);
			}	
		}
	}
}